#ifndef LINUX_POWER_UIHALAPI_H
#define LINUX_POWER_UIHALAPI_H


// IMPORTANT!!! - The following are copied from external/crestron/MC3SDK/include/Armv4i/UIHalAPI.h
// If that file changes, these must change!!!

#define MAX_NAME_LEN 16

//-----------------------------------//
//            Power management
//-----------------------------------//

// define capability bit masks:
#define PM_CAP_ON_PWR_STATE             0x00000001  // 0 = normal power state event not supported, 1 = supported
#define PM_CAP_OFF_PWR_STATE            0x00000002  // 0 = Idle power state event not supported, 1 = supported
#define PM_CAP_CRITICAL_PWR_STATE       0x00000004  // 0 = Idle power state event not supported, 1 = supported
#define PM_CAP_BOOT_PWR_STATE           0x00000008  // 0 = Idle power state event not supported, 1 = supported
#define PM_CAP_IDLE_PWR_STATE           0x00000010  // 0 = Idle power state event not supported, 1 = supported
#define PM_CAP_SYSTEMSUSPEND_PWR_STATE  0x00000020  // 0 = System suspend power state event not supported, 1 = supported
#define PM_CAP_UNATTENDED_PWR_STATE     0x00000040  // 0 = Idle power state event not supported, 1 = supported
#define PM_CAP_RESET_PWR_STATE          0x00000080  // 0 = Reset power state event not supported, 1 = supported
#define PM_CAP_USERIDLE_PWR_STATE       0x00000100  // 0 = User idle power state event not supported, 1 = supported
#define PM_CAP_SYSTEMIDLE_PWR_STATE     0x00000200  // 0 = System idle power state event not supported, 1 = supported
#define PM_CAP_SYSTEM_POWERINFOCHANGE   0x00000400  // 0 = System power info change (AC/Battery status) event not supported, 1 = supported
#define PM_CAP_SYSTEM_POWERSTATUSCHANGE 0x00000800  // 0 = System power switched to/from AC/DC event not supported, 1 = supported
#define PM_CAP_SYSTEM_POWERRESUME       0x00001000  // 0 = System power resume from previous state event not supported, 1 = supported
#define PM_CAP_USBD_STATUS				0x00002000	// 0 = usb device unplugged, 1 = usb plugged in
#define PM_CAP_IS_BATTERY               0x00010000  // 0 = no battery, 1 = has battery
#define PM_CAP_IS_AC                    0x00020000  // 0 = no AC, 1 = has AC power
#define PM_CAP_CHARGE_LED               0x00040000  // 0 = no battery charging LED, 1 = LED exists
#define PM_CAP_POWER_LED                0x00080000  // 0 = no power LED, 1 = LED exists
#define PM_CAP_KEYPAD_WAKE				0x00100000	// 0 = wake on hardkeys disabled, 1 = enabled
#define PM_CAP_TOUCH_WAKE				0x00200000	// 0 = wake on touch screen disabled, 1 = enabled
#define PM_CAP_TOPBUTTON1_WAKE			0x00400000	// 0 = wake on top button 1 disabled, 1 = enabled
#define PM_CAP_TOPBUTTON2_WAKE			0x00800000	// 0 = wake on top button 2 disabled, 1 = enabled
#define PM_CAP_DOCK_WAKE				0x01000000	// 0 = wake on dock (AC on) disabled, 1 = enabled
#define PM_CAP_SUSPENDTIMER_WAKE		0x02000000	// 0 = when suspended, set a timer to wake disabled, 1 = enabled
#define PM_CAP_CHARGEEND_WAKE			0x04000000	// 0 = charging is finished, cant disable
#define PM_CAP_OFN_BUTTON_WAKE			0x08000000	// 0 = wake on OFN buttons disabled, 1 = enabled
#define PM_CAP_OFN_MOTION_WAKE			0x10000000	// 0 = wake on OFN motions disabled, 1 = enabled

typedef enum {
	PM_BATT_AUTOMATIC,
	PM_BATT_MANUAL
} BATTERY_CHARGE_MODE;

unsigned long get_pm_capabilities (void);


//Capability message. Returned from capability get IOCTL
typedef struct UIH_PM_GET_CAPABILITIES {

    long capabilities;                  // capabilities according to the bit masks defined above (0 = not supported; 1 = supported)
    char msg_queue_name[MAX_NAME_LEN];  //Null terminated P2P queue name for event messages
    long que_size;                      //max number of messages in P2P queue.

} UIH_PM_GET_CAPABILITIES;

//Capability set message. Sent with cap set IOCTL
typedef struct UIH_PM_SET_CAPABILITIES {

    long queue_enable;      // 1 = use P2P queue for event messages, 0 = don't use the queue.
    long capabilities;      // capabilities according to the bit masks defined above (0 = disable; 1 = enable)

} UIH_PM_SET_CAPABILITIES;


//#define COMPACTVOLTAGETHRESHOLDS( Use, Critical, Warning ) (((Use & 0x1) << 31) | ((Critical&0x7FFF) << 16) | ((Warning&0xFFFF) << 0))
typedef struct
{
	unsigned int Use : 1;				//0: use battery percent for power broadcast thresholds   1: use voltage thresholds
	unsigned int Critical : 15;			//critical level in mV
	unsigned int Warning : 16;			//warning level in mV
} VoltageThresholds;

// extended commands for power management:
typedef enum {
    ePM_EXTCMD_INVALID          = 0,    // invalid command
    ePM_EXTCMD_ACUSERIDLE,              // set AC user idle period (in seconds)
    ePM_EXTCMD_ACSYSTEMIDLE,            // set AC system idle period (in seconds)
    ePM_EXTCMD_ACSUSPEND,               // set AC suspend period (in seconds)
    ePM_EXTCMD_BATTUSERIDLE,            // set battery user idle period (in seconds)
    ePM_EXTCMD_BATTSYSTEMIDLE,          // set battery system idle period (in seconds)
    ePM_EXTCMD_BATTSUSPEND,             // set battery suspend period (in seconds)
    ePM_EXTCMD_BATTPOLL,                // set battery polling period (in milliseconds)
	ePM_EXTCMD_CCCURREENT,				// set current for Constant Current Mode
	ePM_EXTCMD_CVVOLTAGE,				// set voltage for Constant Voltage Mode
	ePM_EXTCMD_TOTALCHARGETIME,         // set total charge time
	ePM_EXTCMD_AUTOCHARGE,				// disable battery charge
	ePM_EXTCMD_SUSPENDCHARGE,			// suspend battery charge
	ePM_EXTCMD_CHARGECURRENT,			// change battery current?
	ePM_EXTCMD_USE_VOLTAGE_THRESHOLDS,	// set VoltageThresholds struct
	ePM_EXTCMD_FULLCAPACITY,			// set battery charge level that represents 100% to user (LED charging indicator)
	ePM_EXTCMD_SUSPENDTIMER,			// set number of seconds to stay in suspend before waking up (0=never wake up from RTC)
	ePM_EXTCMD_SHUTDOWN,				// full power supply shutdown, system will reboot when power is restored (docked)
	ePM_EXTCMD_INIT_GAS_GAUGE_EEPROM,	// force initialization of gas gauge EEPROM, even if initialized
    ePM_EXTCMD_MAXCOMMANDS              // maximum number of commands + 1
} ENUM_PM_EXTCMD;

//Set message. Sent with set IOCTL
typedef struct UIH_PM_SET_MESSAGE {

    long power_led_enable;              // enable power LED: 0 = disable, 1 = enable
    long battery_critical_level;        // set battery critical level threshold (0 - 100%)
    long battery_warning_level;         // set battery warning level threshold (0 - 100%)
    long warning_led_flash_rate;        // set battery warning level LED flash rate
    long charging_led_flash_rate;       // set battery charging LED flash rate
    long ext_cmd;                       // extended command (as defined ENUM_PM_EXTCMD above), must be set to ePM_EXTCMD_INVALID for non extended settings above
    union
	{
		VoltageThresholds Thresholds;
		long ext_param;
	};                     // parameter/value for the extended command

} UIH_PM_SET_MESSAGE;

//To use the extended get commands, issue the IOCTL_UIHAL_GET_STATUS_PM with
//a UIH_PM_GET_MESSAGE in pInBuf.  Passing in a null pInBuf will use the original get status message structure
//command must contain ePM_EXTCMD
//number_of_commands contains the number of values in the ext_cmd array
//ext_cmd contains an array of number_of_commands ENUM_PM_EXTGETCMD values
//it will return an array of number_of_commands elements each of size DWORD in the same order as the commands
//ePM_EXTGETCMD_GAS_GAUGE_REGISTERS and ePM_EXTGETCMD_CHARGER_REGISTERS are special cases, cant use as part of array of multiple commands and will return more than 1 byte
typedef enum {
    ePM_EXTCMD = 1000,					// use extended get message
} ENUM_PM_CMD;

typedef enum {
	ePM_EXTGETCMD_BATTERYCHEMISTRY,		// get current for Constant Current Mode
	ePM_EXTGETCMD_CHARGEMODE,			// get voltage for Constant Voltage Mode
	ePM_EXTGETCMD_CCCURREENT,			// get current for Constant Current Mode
	ePM_EXTGETCMD_CVVOLTAGE,			// get voltage for Constant Voltage Mode
	ePM_EXTGETCMD_TOTALCHARGETIME,      // get total charge time
	ePM_EXTGETCMD_CURRENTCHARGETIME,
	ePM_EXTGETCMD_LASTWAKEUP,			// get last wakeup source
	ePM_EXTGETCMD_AUTOCHARGE,			// currently returns invalid value.  no way to reliably tell if pmic is in automatic control or not
	ePM_EXTGETCMD_SUSPENDCHARGE,		// get battery charge suspend state
	ePM_EXTGETCMD_CHARGECURRENT,		// get battery current
	ePM_EXTGETCMD_FULLCAPACITY,			// get battery percentage that represents full charge
	// JAS - uncomment the next line if we need to be able to read the suspend timer (not in CE code)
	//ePM_EXTGETCMD_SUSPENDTIMER,			// set wakeup time for suspend timer (in seconds)
	ePM_EXTGETCMD_BATTERYVOLTAGE,		// get battery voltage (in mV)
	ePM_EXTGETCMD_VOLTAGE_THRESHOLDS,	// get VoltageThresholds struct
	//ePM_EXTGETCMD_GAS_GAUGE_REGISTERS and ePM_EXTGETCMD_CHARGER_REGISTERS will return a UIH_PM_REGISTER_MESSAGE struct with an array of UIH_PM_REGISTERS,
	//if number_of_registers is 0, size_of_buffer_needed will return the number of required bytes,
	//otherwise will return number of registers written
	ePM_EXTGETCMD_GAS_GAUGE_REGISTERS,	// get gas gauge registers
	ePM_EXTGETCMD_CHARGER_REGISTERS,	// get charger registers
	ePM_EXTGETCMD_BATTERYCURRENT,		// get battery current (in mA), signed value
	ePM_EXTGETCMD_USBD_STATUS,			// get USB Device connection status (0: disconnected, 1: connected)
    ePM_EXTGETCMD_MAXCOMMANDS           // maximum number of commands + 1
} ENUM_PM_EXTGETCMD;

typedef struct UIH_PM_GET_MESSAGE {
	ENUM_PM_CMD command;				// command type
	long number_of_commands;			// number of ext_cmd entries
	long* ext_cmd;                      // if ePM_EXTCMD, use extended command (as defined ENUM_PM_EXTGETCMD above)
} UIH_PM_GET_MESSAGE;

//Get message. Sent with get IOCTL
typedef struct UIH_PM_STATUS_MESSAGE {

    long on_AC;                         // AC status: 0 = not on AC, 1 = on AC
    long battery_level;                 // current battery level (0 - 100%)
    long battery_charging;              // battery charging status: //0 = actually not charging,
																	//1 = charging,
																	//2 = display not charging, but is charging beyond user 100%
    long power_led_enable;              // enable power LED: 0 = disabled, 1 = enabled
    long battery_critical_level;        // battery critical level threshold (0 - 100%)
    long battery_warning_level;         // battery warning level threshold (0 - 100%)
    long warning_led_flash_rate;        // battery warning level LED flash rate
    long charging_led_flash_rate;       // battery charging LED flash rate

} UIH_PM_STATUS_MESSAGE;

typedef struct UIH_PM_REGISTERS {
    long register_address;				// register address
    char register_name[MAX_NAME_LEN];	// set battery critical level threshold (0 - 100%)
    long register_value;				// set battery warning level threshold (0 - 100%)
    long converted_value;				// set battery warning level LED flash rate
    char converted_units[MAX_NAME_LEN];	// set battery charging LED flash rate
} UIH_PM_REGISTERS;

typedef struct UIH_PM_REGISTER_MESSAGE {
	long size_of_buffer_needed;			// total size of required structure
    long number_of_registers;			// number of registers in array
	UIH_PM_REGISTERS registers[1];		// variable length array with number_of_registers elements
} UIH_PM_REGISTER_MESSAGE;



//-----------------------------------------------------------
// Define power management event types and associated values:
// NOTE: The following event types should be mutually exclusive; except for screen backlight which may be combined with other event types
#define PM_EVENT_TYPE_STATE_ON          (DWORD)(0x00000001) // power transition -> on state
#define PM_EVENT_TYPE_STATE_OFF         (DWORD)(0x00000002) // power transition -> no power, full off
#define PM_EVENT_TYPE_STATE_CRITICAL    (DWORD)(0x00000004) // power transition -> critical off
#define PM_EVENT_TYPE_STATE_BOOT        (DWORD)(0x00000008) // power transition -> boot state
#define PM_EVENT_TYPE_STATE_IDLE        (DWORD)(0x00000010) // power transition -> idle state
#define PM_EVENT_TYPE_STATE_SUSPEND     (DWORD)(0x00000020) // power transition -> suspend state
#define PM_EVENT_TYPE_STATE_UNATTENDED  (DWORD)(0x00000040) // power transition -> Unattended state.
#define PM_EVENT_TYPE_STATE_RESET       (DWORD)(0x00000080) // power transition -> reset state
#define PM_EVENT_TYPE_STATE_USERIDLE    (DWORD)(0x00000100) // power transition -> user idle state
#define PM_EVENT_TYPE_STATE_SYSTEMIDLE  (DWORD)(0x00000200) // power transition -> system idle state
#define PM_EVENT_TYPE_POWERINFOCHANGE   (DWORD)(0x00100000) // Power info change event (i.e. changes in AC and/or Battery status)
#define PM_EVENT_TYPE_POWERSTATUSCHANGE (DWORD)(0x00200000) // Power supply switched to/from AC/DC
#define PM_EVENT_TYPE_POWERRESUME       (DWORD)(0x00400000) // Power resume from previous state
#define PM_EVENT_TYPE_STATE_BACKLIGHTON (DWORD)(0x02000000) // device screen backlight on
#define PM_EVENT_TYPE_USBD_STATUS		(DWORD)(0x04000000) // usb device plugged in/unplugged

// POWERINFOCHANGE event: AC status can only be one of the following values:
#define PM_EVENT_VAL_AC_OFFLINE         0
#define PM_EVENT_VAL_AC_ONLINE          1
#define PM_EVENT_VAL_AC_UNKNOWN         255

// POWERINFOCHANGE event: battery status may be a combination of the following values:
#define PM_EVENT_VAL_BATT_HIGH          0x01
#define PM_EVENT_VAL_BATT_LOW           0x02
#define PM_EVENT_VAL_BATT_CRITICAL      0x04
#define PM_EVENT_VAL_BATT_CHARGING      0x08
#define PM_EVENT_VAL_BATT_NONEXIST      0x80
#define PM_EVENT_VAL_BATT_UNKNOWN       0xFF

// POWERINFOCHANGE event: define a value structure for AC and battery:
typedef struct _POWER_INFO_STRUCT {
    unsigned char   AC_status;
    unsigned char   battery_status;
    unsigned char   battery_life_percent;   // battery life/level percentage (0 - 100%)
    unsigned char   reserved;
    long            battery_life_time;      // battery life remaining time (in seconds)
} POWER_INFO_STRUCT;

//Event message. Sent to P2P queue when a power event occurs
typedef struct UIH_PM_EVENT_MESSAGE {

    long event_type;
    union {
        long                event_value;    // normally zero; except for PM_EVENT_TYPE_POWERSTATUSCHANGE this will be AC_status
											// event_value for PM_EVENT_TYPE_USBD_STATUS - 0 = unplugged, 1 = plugged in
        POWER_INFO_STRUCT   power_info;     // AC/battery status as defined above
    };

} UIH_PM_EVENT_MESSAGE;


#endif
